//
// Walk Straight
//  angles for XBlast robot walking straight ahead
//  1 wclock = 2 steps for 4 units
//
// based on code (C) by Oliver Vogel (e-mail: m.vogel@ndh.net)
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published
// by the Free Software Foundation; either version 2; or (at your option)
// any later version
//
// This program is distributed in the hope that it will be entertaining,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILTY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
// Public License for more details.
//
// You should have received a copy of the GNU General Public License along
// with this program; if not, write to the Free Software Foundation, Inc.
// 675 Mass Ave, Cambridge, MA 02139, USA.
//

// declare walk clock (if needed)
#ifndef (wclock)
  #declare wclock = clock
#end

//
// lots of trigonometrical functions
//
#declare COS = cos(radians(wclock*360))
#declare SIN = sin(radians(wclock*360))

#if (COS > 0.0)
  #declare PCOS = COS
  #declare MCOS = 0.0
#else
  #declare PCOS = 0.0
  #declare MCOS = COS
#end

#if (SIN > 0.0)
  #declare PSIN = SIN
  #declare MSIN = 0.0
#else
  #declare PSIN = 0.0
  #declare MSIN = SIN
#end

#declare P2SIN=PSIN*PSIN
#declare M2SIN=-MSIN*MSIN
#declare P2COS=PCOS*PCOS
#declare M2COS=-MCOS*MCOS

#declare COS2=COS*COS
#declare SIN2=SIN*SIN

//
// the movement pattern
//
#declare leftLowerArmAngle  = <  -15,  25*P2SIN    , -30>;
#declare leftArmAngle       = <   15,  20*COS  +  5, -45>;
#declare rightLowerArmAngle = <  -15,  25*M2SIN    ,  30>;
#declare rightArmAngle      = <   15,  20*COS  -  5,  45>;

#declare rightLowerLegAngle = <  30*M2COS -  5,  0,  0>;
#declare rightLegAngle      = <  25*SIN   +  5, 15,  0>;
#declare leftLowerLegAngle  = < -30*P2COS -  5,  0,  0>;
#declare leftLegAngle       = < -25*SIN   +  5,-15,  0>;

#declare rightFootAngle     = < -10*SIN, 0, 0>;
#declare leftFootAngle      = <  10*SIN, 0, 0>;

#declare playerWalkHeight   = 0

